/*---------------------------------------------------------------------------*\

    FILE....: OSC.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 6/11/97

    Digital ocillator strcuture and functions.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __OSC__
#define __OSC__

#include "contypes.h"

/* digital oscillator state variables */

typedef struct {
    float freq;	        /* 2cos(w)				        */
    float mag;		/* 0dBm0 = 32767				*/
    float y1;		/* y(n-1)					*/
    float y2;		/* y(n-2)					*/
} OSC;

/*--------------------------------------------------------------------------*\

				FUNCTIONS

\*--------------------------------------------------------------------------*/

void osc_init(OSC *osc, short freq, USHORT mag);
void osc_oscillate(OSC *osc, short buf[], USHORT n);

#endif	/* #ifndef __OSC__	*/

